<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Clients extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'password', 'phone', 'date_of_birth', 'pin_code');

    public function clients()
    {
        return $this->belongsTo('Cities');
    }

    public function blood_type()
    {
        return $this->belongsTo('BloodType');
    }

    public function posts()
    {
        return $this->hasMany('Posts');
    }

    public function donation_requests()
    {
        return $this->hasMany('DonationRequest');
    }

    public function contacts()
    {
        return $this->hasMany('Contact');
    }

    public function notifications()
    {
        return $this->hasMany('Notification');
    }

}